<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// API Key PayFort
$apiKey = 'yfMBsceFunBXAbddxT8sP8+oueHv8PuKHfKQvgyw3vGjRpEf1894xfmvJa9BdN5x';

// Endpoint PayFort Cash-In
$endpoint = 'https://cashin.safepayments.cloud/transaction/qrcode/cashin';

// Obter parâmetros da requisição
$customer_cpf = $_GET['customer_cpf'] ?? $_POST['customer_cpf'] ?? '';
$customer_name = $_GET['customer_name'] ?? $_POST['customer_name'] ?? '';
$customer_email = $_GET['customer_email'] ?? $_POST['customer_email'] ?? '';
$customer_phone = $_GET['customer_phone'] ?? $_POST['customer_phone'] ?? '';
$value = $_GET['value'] ?? $_POST['value'] ?? 16180; // Valor padrão em centavos (R$ 161,80)

// Validar dados obrigatórios
if (empty($customer_cpf) || empty($customer_name)) {
    http_response_code(400);
    echo json_encode([
        'error' => 'Dados incompletos',
        'message' => 'CPF/CNPJ e nome são obrigatórios'
    ]);
    exit;
}

// Gerar orderId único
$orderId = 'EBOOK-' . time() . '-' . substr(md5($customer_cpf), 0, 8);

// URL de callback para webhook (ajuste conforme necessário)
$postbackUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . 
               '://' . $_SERVER['HTTP_HOST'] . 
               dirname($_SERVER['PHP_SELF']) . 
               '/webhook-payment.php';

// Preparar dados para a API PayFort
$payload = [
    'payerName' => $customer_name,
    'payerDocument' => preg_replace('/\D/', '', $customer_cpf), // Remove formatação
    'payerEmail' => !empty($customer_email) ? $customer_email : "contato{$customer_cpf}@email.com",
    'payerPhone' => !empty($customer_phone) ? preg_replace('/\D/', '', $customer_phone) : '61999999999',
    'productName' => 'deposito ebook 07',
    'productDescription' => 'Pagamento de ebook',
    'value' => (int)$value, // Valor em centavos
    'postbackUrl' => $postbackUrl,
    'orderId' => $orderId
];

// Fazer requisição para PayFort
$ch = curl_init($endpoint);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey
    ],
    CURLOPT_SSL_VERIFYPEER => true,
    CURLOPT_TIMEOUT => 30
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

// Verificar erros de conexão
if ($curlError) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Erro na conexão',
        'message' => $curlError
    ]);
    exit;
}

// Verificar código HTTP
if ($httpCode !== 200 && $httpCode !== 201) {
    http_response_code($httpCode);
    echo json_encode([
        'error' => 'Erro na API PayFort',
        'httpCode' => $httpCode,
        'response' => $response
    ]);
    exit;
}

// Decodificar resposta
$responseData = json_decode($response, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Resposta inválida da API',
        'message' => json_last_error_msg()
    ]);
    exit;
}

// Verificar se a resposta contém os dados necessários
// PayFort pode retornar transactionId ou transaction_id, e pixCode pode ter nomes diferentes
$transactionId = $responseData['transactionId'] ?? $responseData['transaction_id'] ?? null;
$pixCode = $responseData['pixCode'] ?? $responseData['qrCode'] ?? $responseData['qrcode'] ?? $responseData['pix'] ?? null;

if (!$transactionId || !$pixCode) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Resposta incompleta da API',
        'response' => $responseData,
        'message' => 'transactionId ou pixCode não encontrados na resposta'
    ]);
    exit;
}

// Retornar dados no formato esperado pelo frontend
echo json_encode([
    'transactionId' => $transactionId,
    'transaction_id' => $transactionId, // Compatibilidade
    'pixCode' => $pixCode,
    'qrCodePix' => $pixCode, // Compatibilidade
    'amount' => $value,
    'status' => 'created',
    'orderId' => $orderId
]);
?>
